<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class PurchaseModel extends Model
{
    protected $table = 'purchases';
    protected $primaryKey = 'id';
    
    protected $fillable = [
        'purchase_code',
        'branch_id', 
        'purchase_date',
        'total_amount',
        'paid_amount',
        'due_amount',
        'status',
        'notes',
        'active_flag'
    ];

    protected $casts = [
        'purchase_date' => 'date',
        'total_amount' => 'decimal:2',
        'paid_amount' => 'decimal:2',
        'due_amount' => 'decimal:2',
    ];

    // Use existing tables as relationships
    public function productDetails()
    {
        return $this->hasMany(ProductDetailsModel::class, 'purchase_id');
    }

    public function payments()
    {
        return $this->hasMany(ProductPaymentModel::class, 'purchase_id');
    }

    public function branch()
    {
        return $this->belongsTo(BranchModel::class, 'branch_id');
    }
}
