

<?php $__env->startSection('content'); ?>
    <div class="main-content">
        <div class="row">
            <div class="col-12">
                <div class="card mb-4 mx-4">
                    <form action="<?php echo e(route('branch-update', $branch->id)); ?>" method="POST" enctype="multipart/form-data">
                        <div class="card-header pb-0">
                            <div class="d-flex flex-row justify-content-between">
                                <div>
                                    <h5 class="mb-0">Edit Branch</h5>
                                </div>
                            </div>
                        </div>

                        <div class="card-body">
                            <?php echo csrf_field(); ?>
                            <input type="hidden" name="branch_id" value="<?php echo e($branch->id); ?>">
                            <div class="row">
                                <!-- First Column: Company, Prefix, Address, Send Invoice -->
                                <div class="col-lg-4">
                                    <div class="col-lg-12 mb-3">
                                        <label for="company" class="form-label">Company:</label>
                                        <select name="company" id="company" class="form-select">
                                            <option value="">Select Company</option>
                                            <?php $__currentLoopData = $companies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $company): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($company->id); ?>" <?php echo e($branch->company_id == $company->id ? 'selected' : ''); ?>>
                                                    <?php echo e($company->name); ?>

                                                </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                        <?php $__errorArgs = ['company'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="text-danger"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>

                                    <div class="col-lg-12 mb-3">
                                        <label for="prefix" class="form-label">Prefix:</label>
                                        <input type="text" name="prefix" class="form-control"
                                            value="<?php echo e(old('prefix', $branch->prefix)); ?>" required>
                                        <?php $__errorArgs = ['prefix'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="text-danger"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>

                                    <div class="col-lg-12 mb-3">
                                        <label for="address" class="form-label">Address:</label>
                                        <input type="text" name="address" class="form-control"
                                            value="<?php echo e(old('address', $branch->address)); ?>">
                                        <?php $__errorArgs = ['address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="text-danger"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>

                                    <div class="col-lg-12 mb-3">
                                        <label for="loyalty_amount" class="form-label">Loyalty Amount</label>
                                        <input type="text" name="loyalty_amount" id="loyalty_amount" class="form-control"
                                            value=" <?php echo e(old('loyalty_amount', $branch->loyalty_amount)); ?>">
                                        <?php $__errorArgs = ['loyalty_amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="text-danger"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>

                                </div>

                                <!-- Second Column: Branch Name, Contact Number, Default User, Logo -->
                                <div class="col-lg-4">
                                    <div class="col-lg-12 mb-3">
                                        <label for="name" class="form-label">Branch Name:</label>
                                        <input type="text" name="name" class="form-control"
                                            value="<?php echo e(old('name', $branch->name)); ?>" required>
                                        <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="text-danger"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>

                                    <div class="col-lg-12 mb-3">
                                        <label for="contact_number" class="form-label">Contact Number:</label>
                                        <input type="text" name="contact_number" class="form-control"
                                            value="<?php echo e(old('contact_number', $branch->phone)); ?>">
                                        <?php $__errorArgs = ['contact_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="text-danger"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>

                                    <div class="col-lg-12 mb-3">
                                        <label for="user_id" class="form-label">Default User:</label>
                                        <select name="user_id" id="user_id" class="form-select">
                                            <option value="">Select User</option>
                                            <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($user->id); ?>" <?php echo e($user_id == $user->id ? 'selected' : ''); ?>>
                                                    <?php echo e($user->name); ?>

                                                </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                        <?php $__errorArgs = ['user_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="text-danger"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>

                                    <div class="col-lg-12 mb-3">
                                        <label for="point_redemption" class="form-label">Loyalty Point Value</label>
                                        <input type="number" name="point_redemption" id="point_redemption"
                                            class="form-control"
                                            value="<?php echo e(old('point_redemption', $branch->point_redemption)); ?>">
                                        <?php $__errorArgs = ['point_redemption'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="text-danger"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>

                                </div>

                                <!-- Third Column: GST No, Email, Paper Size -->
                                <div class="col-lg-4">
                                    <div class="col-lg-12 mb-3">
                                        <label for="gst_no" class="form-label">GST No:</label>
                                        <input type="text" name="gst_no" class="form-control"
                                            value="<?php echo e(old('gst_no', $branch->gst_no)); ?>" required>
                                        <?php $__errorArgs = ['gst_no'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="text-danger"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>

                                    <div class="col-lg-12 mb-3">
                                        <label for="email" class="form-label">Email:</label>
                                        <input type="email" name="email" class="form-control"
                                            value="<?php echo e(old('email', $branch->email)); ?>">
                                        <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="text-danger"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>

                                    <div class="col-lg-12 mb-3">
                                        <label for="paper_size" class="form-label">Standard Paper:</label>
                                        <select name="paper_size" id="paper_size" class="form-select">
                                            <option value="">Select Standard</option>
                                            <?php $__currentLoopData = $paperSize; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $size): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($size->id); ?>" <?php echo e($branch->paper_size == $size->id ? 'selected' : ''); ?>><?php echo e($size->name); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                        <?php $__errorArgs = ['paper_size'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="text-danger"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>

                                </div>
                            </div>
                            <div class="col-lg-12 mb-3 table-responsive d-flex justify-content-center">
                                <table class="table table-bordered text-xs w-auto">
                                    <thead>
                                        <tr>
                                            <th>Send Invoice</th>
                                            <th>Loyalty Point</th>
                                            <th>Note</th>
                                            <th>Term</th>
                                            <th>Description</th>
                                            <th>Tax</th>
                                            <th>Signature</th>
                                            <th>Available Qty Validate</th>
                                            <th>Native Name</th>
                                            <th>Is Header</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td class="text-center">
                                                <input type="checkbox" name="send_invoice" id="send_invoice"
                                                    style="width: 18px; height: 18px;" value="A" <?php echo e(old('send_invoice', $branch->whatsapp_config) == 'A' ? 'checked' : ''); ?>>
                                                <?php $__errorArgs = ['send_invoice'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><span
                                                class="text-danger"><?php echo e($message); ?></span><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </td>
                                            <td class="text-center">
                                                <input type="checkbox" name="loyalty_point" id="loyalty_point"
                                                    style="width: 18px; height: 18px;" value="A" <?php echo e(old('loyalty_point', $branch->loyalty_config) == 'A' ? 'checked' : ''); ?>>
                                                <?php $__errorArgs = ['loyalty_point'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><span
                                                class="text-danger"><?php echo e($message); ?></span><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </td>
                                            <td class="text-center">
                                                <input type="checkbox" name="note" id="note"
                                                    style="width: 18px; height: 18px;" value="1" <?php echo e(old('note', $branch->note_flag) == 'A' ? 'checked' : ''); ?>>
                                                <?php $__errorArgs = ['note'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><span class="text-danger"><?php echo e($message); ?></span><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </td>
                                            <td class="text-center">
                                                <input type="checkbox" name="term" id="term"
                                                    style="width: 18px; height: 18px;" value="1" <?php echo e(old('term', $branch->terms_flag) == 'A' ? 'checked' : ''); ?>>
                                                <?php $__errorArgs = ['term'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><span class="text-danger"><?php echo e($message); ?></span><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </td>
                                            <td class="text-center">
                                                <input type="checkbox" name="description" id="description"
                                                    style="width: 18px; height: 18px;" value="1" <?php echo e(old('description', $branch->inv_desc_flag) == 'A' ? 'checked' : ''); ?>>
                                                <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><span
                                                class="text-danger"><?php echo e($message); ?></span><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </td>
                                            <td class="text-center">
                                                <input type="checkbox" name="price_tax" id="price_tax"
                                                    style="width: 18px; height: 18px;" value="1" <?php echo e(old('price_tax', $branch->price_tax_flag) == 'A' ? 'checked' : ''); ?>>
                                                <?php $__errorArgs = ['price_tax'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><span class="text-danger"><?php echo e($message); ?></span><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </td>
                                            <td class="text-center">
                                                <input type="checkbox" name="signature" id="signature"
                                                    style="width: 18px; height: 18px;" value="1" <?php echo e(old('signature', $branch->signature_flag) == 'A' ? 'checked' : ''); ?>>
                                                <?php $__errorArgs = ['signature'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><span class="text-danger"><?php echo e($message); ?></span><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </td>
                                            <td class="text-center">
                                                <input type="checkbox" name="avl_qty" id="avl_qty"
                                                    style="width: 18px; height: 18px;" value="1" <?php echo e(old('avl_qty', $branch->avl_qty_flag) == 'A' ? 'checked' : ''); ?>>
                                                <?php $__errorArgs = ['avl_qty'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><span class="text-danger"><?php echo e($message); ?></span><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </td>
                                            <td style="padding: 10px; text-align: center;">
                                                <input type="checkbox" name="native_name" id="native_name"
                                                    style="width: 18px; height: 18px;" value="1" <?php echo e(old('avl_qty', $branch->native_name_flag) == 'A' ? 'checked' : ''); ?>>
                                                <?php $__errorArgs = ['avl_qty'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><span class="text-danger"><?php echo e($message); ?></span><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </td>
                                            <td style="padding: 10px; text-align: center;">
                                                <input type="checkbox" name="is_header" id="is_header"
                                                    style="width: 18px; height: 18px;" value="1" <?php echo e(old('is_header', $branch->is_header) == 'A' ? 'checked' : ''); ?>>
                                                <?php $__errorArgs = ['is_header'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><span class="text-danger"><?php echo e($message); ?></span><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>

                            <div class="col-lg-12 mb-3">
                                <label for="declaration" class="form-label">Terms & Condition</label>
                                <textarea name="declaration" class="form-control"
                                    rows="2"> <?php echo e(old('declaration', $branch->declaration ?? '')); ?></textarea>
                                <?php $__errorArgs = ['declaration'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="text-danger"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="col-lg-12 mb-3">
                                <label for="logo" class="form-label">Logo:</label>
                                <div class="d-flex align-items-center mt-2" style="height: 50px;width: 430px;">
                                    <div class="avatar-upload me-5">
                                        <div class="avatar-preview">
                                            <?php if($branch->logo): ?>
                                                <img id="logoPreview" src="<?php echo e(getFileUrl($branch->logo)); ?>" alt="Branch Logo"
                                                    class="img-fluid mt-4" style="height: 80px; width: auto; max-width:250px;">
                                            <?php else: ?>
                                                <img id="logoPreview" src="<?php echo e(asset('assets/img/logos/Product.png')); ?>"
                                                    alt="Default Image" class="img-fluid mt-4"
                                                    style="height: 80px; width: auto; max-width:250px;">
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                    <div class="avatar-edit">
                                        <input type="file" id="logo" class="form-control file-upload-input mb-3"
                                            accept="image/*" name="logo" onchange="previewLogo(this)">
                                        <small class="text-muted d-block mt-1">Recommended size:
                                            <strong>781x320</strong> pixels</small>
                                    </div>
                                </div>
                                <?php $__errorArgs = ['logo'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="text-danger"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="card-footer">
                                <button type="submit" class="btn btn-primary ms-0">Update Branch</button>
                                <a href="<?php echo e(route('branch-index')); ?>" class="btn btn-secondary">Cancel</a>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script>
        function previewLogo(input) {
            const preview = document.getElementById('logoPreview');
            const file = input.files[0];
            const reader = new FileReader();

            reader.onloadend = function () {
                preview.src = reader.result;
            }

            if (file) {
                reader.readAsDataURL(file);
            } else {
                preview.src = "<?php echo e($branch->logo ? getFileUrl($branch->logo) : asset('assets/img/logos/Product.png')); ?>";
            }
        }
    </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.layoutapp', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /opt/lampp/htdocs/lara_commonbilling_new/resources/views/branch/edit.blade.php ENDPATH**/ ?>