<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PaymentsModel extends Model
{
    use HasFactory;
    protected $table = 'payments';
    protected $primaryKey = 'id';
    public $timestamps = true;
    protected $fillable = [
        'invoice_id',
        'amount',
        'payment_date',
        'total_amount',
        'payment_mode',
        'transaction_id',
        'notes',
        'is_approved',
        'invoioce_emi_dtls_id',
        'oprntl_flag'
    ];
    public function invoice()
    {
        return $this->belongsTo(InvoiceModel::class, 'invoice_id');
    }
    public function mode()
    {
        return $this->belongsTo(PaymentModeModel::class, 'payment_mode');
    }
    const UPI = 1;

    const ONLINE = 2;

    const CASH = 3;

    const PAYMENT_MODE = [
        self::UPI => 'UPI',
        self::ONLINE => 'Online',
        self::CASH => 'Cash',
    ];
}
