<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class OrdersModel extends Model
{
    protected $table = 'orders';
    protected $primaryKey = 'id';
    protected $fillable = [
        'order_id',
        'client_id',
        'order_date',
        'due_date',
        'amount',
        'final_amount',
        'discount_type',
        'discount',
        'note',
        'term',
        'branch_id',
        'template_id',
        'recurring',
        'status',
        'gst',
        'oprntl_flag',
        'client_address_id',
    ];
    protected $dates = [
        'order_date',
        'due_date',
        'created_at',
        'updated_at',
    ];
    public function client()
    {
        return $this->belongsTo(ClientModel::class);
    }
    public function user()
    {
        return $this->belongsTo(User::class);
    }
    public function ordersItem()
    {
        return $this->hasMany(OrdersItemsModel::class, 'order_id', 'id');
    }
    public function branch()
    {
        return $this->belongsTo(BranchModel::class, 'branch_id');
    }
    public function invoices()
    {
        return $this->hasMany(InvoiceModel::class, 'quote_id');
    }
    public function clientAddress(){
        return $this->belongsTo(ClientAddressModel::class,'client_address_id');
    }
}
