<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class OrdersItemsModel extends Model
{
    protected $table = 'order_items';
    protected $primaryKey = 'id';
    protected $fillable = [
        'order_id',
        'product_id',
        'product_name',
        'available_quantity',
        'quantity',
        'price',
        'total',
    ];
    public function order()
    {
        return $this->belongsTo(OrdersModel::class, 'order_id');
    }
    public function product()
    {
        return $this->belongsTo(ProductModel::class, 'product_id');
    }   
}
