<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class AssembledItemModel extends Model
{
    protected $table = 'assembled_item';
    protected $primaryKey = 'id';
    protected $fillable = [
        'branch_id',
        'assemble_date',
        'bom_id',
        'assembled_item',
        'assembled_qty',
        'remarks',
        'per_unit_cost',
        'total_amount',
        'oprntl_flag',
        'created_by',
        'created_at',
        'updated_at',
        'product_id',
    ];
    public function bom()
    {
        return $this->belongsTo(BOMModel::class, 'bom_id');
    }

    public function product()
    {
        return $this->belongsTo(ProductModel::class, 'product_id');
    }
}
